function reducedMat = combineCells(obj,rowGroups,columnGroups)
%COMBINECELLS Combine cells in AdjacencyMatrix obj, adding together their
%inputs and outputs
%   redMat = COMBINECELLS(obj,rowGroups,columnGroups) will combine neurons
%   into meta-nodes 
%   
%   rowGroups and columnGroups argument should be a list
%   alternating meta-node name, and a cell array of strings which are its
%   constituent cells ex. reducedMat =
%   combineCells(chem,{'R9',{'R9BR','R9BL','R9AR','R9AL'}},{'R9',{'R9BR','R9BL','R9AR','R9AL'}});
% 
%   WARNING: be sure that the new meta-node names are not the same as any
%   of the preexisting node names


% build multiplying matrix for columns
mat = eye(size(obj.A,2));
newColLabels = obj.columnLabels;
for i = 1:2:length(columnGroups)
    matches = matchStringLists(obj.columnLabels,columnGroups{i+1});
    if sum(matches)==0, continue; end  %Make sure this is not an empty meta-cell
    idxs = find(matches);
    mat(:,idxs) = zeros(size(mat,1),numel(idxs));
    newColLabels(matchStringLists(newColLabels,columnGroups{i+1})) = [];
    newColLabels = [newColLabels columnGroups{i}];
    mat(:,size(mat,2)+1) = matches';
end

newA = obj.A*mat;


%build multiplying matrix for rows
mat = eye(size(obj.A,1));
newRowLabels = obj.rowLabels;
for i = 1:2:length(rowGroups)
    matches = matchStringLists(obj.rowLabels,rowGroups{i+1});
    if sum(matches)==0, continue; end %Make sure this is not an empty meta-cell
    idxs = find(matches);
    mat(idxs,:) = zeros(numel(idxs),size(mat,2));
    newRowLabels(matchStringLists(newRowLabels,rowGroups{i+1})) = [];
    newRowLabels = [newRowLabels ; rowGroups{i}];
    mat(size(mat,1)+1,:) = matches';
end

newA = mat*newA;
newA(:,sum(newA,1)==0) = [];
newA(sum(newA,2)==0,:) = [];


reducedMat = AdjacencyMatrix(newA,newRowLabels,newColLabels);



% disp(AdjacencyMatrix.muscles(matchStringLists(AdjacencyMatrix.muscles,{obj.cells.name})));

    function matches = matchStringLists(target,strings)
        matches = false(size(target));
        for kk = 1:numel(strings)
            matches = matches | strcmp(target,strings{kk});
        end
    
    end


end
